module RPG
  class Animation
    def initialize
      @id = 0
      @name = ""
      @animation_name = ""
      @animation_hue = 0
      @position = 1
      @frame_max = 1
      @frames = [RPG::Animation::Frame.new]
      @timings = []
    end
    attr_accessor :id
    attr_accessor :name
    attr_accessor :animation_name
    attr_accessor :animation_hue
    attr_accessor :position
    attr_accessor :frame_max
    attr_accessor :frames
    attr_accessor :timings


    ###########################################
    # Ajouts aux classes
    ###########################################

    def to_dmk
      my = self.cast(My_RPG::My_Animation)
      return my
    end


    def comparer(anim)
      #return false if super(anim) == false


      if @id != anim.id
        raise(DMKW_DMK_Diff.new("anim.id"))
      end
      if @name != anim.name
        raise(DMKW_DMK_Diff.new("anim.name"))
      end
      if @animation_name != anim.animation_name
        raise(DMKW_DMK_Diff.new("anim.animation_name"))
      end
      if @animation_hue != anim.animation_hue
        raise(DMKW_DMK_Diff.new("anim.animation_hue"))
      end
      if @position != anim.position
        raise(DMKW_DMK_Diff.new("anim.position"))
      end
      if @frame_max != anim.frame_max
        raise(DMKW_DMK_Diff.new("anim.frame_max"))
      end
      if @frames != anim.frames
        raise(DMKW_DMK_Diff.new("anim.frames"))
      end
      if @timings != anim.timings
        raise(DMKW_DMK_Diff.new("anim.timings"))
      end
      return true
    end


  end
end
